// GpMView.cpp : CGpMView Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpMView

IMPLEMENT_DYNCREATE(CGpMView, CScrollView)

BEGIN_MESSAGE_MAP(CGpMView, CScrollView)
	//{{AFX_MSG_MAP(CGpMView)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_GpPenEscT, OnGpPenEscT)
	ON_COMMAND(ID_GpPenEsc_b, OnGpPenEscb)
	ON_COMMAND(ID_GpPenEsc_c, OnGpPenEscc)
	ON_COMMAND(ID_GpPenEsc_g, OnGpPenEscg)
	ON_COMMAND(ID_GpPenEsc_l, OnGpPenEscl)
	ON_COMMAND(ID_GpPenEsc_s, OnGpPenEscs)
	ON_COMMAND(ID_GpPenEsc_t, OnGpPenEsct)
	ON_COMMAND(ID_GpPenEscA, OnGpPenEscA)
	ON_COMMAND(ID_GpPenEscB, OnGpPenEscB)
	ON_COMMAND(ID_GpPenEscC, OnGpPenEscC)
	ON_COMMAND(ID_GpPenEscG, OnGpPenEscG)
	ON_COMMAND(ID_GpPenEscL, OnGpPenEscL)
	ON_COMMAND(ID_GpPenEscP, OnGpPenEscP)
	ON_COMMAND(ID_GpPenEscS, OnGpPenEscS)
	ON_COMMAND(ID_GpPenEscY, OnGpPenEscY)
	ON_COMMAND(ID_GpPenEsc_y, OnGpPenEscy)
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_Adjust, OnAdjust)
	ON_COMMAND(ID_Message, OnShowMessage)
	ON_COMMAND(ID_LINK, OnLink)
	ON_WM_CHAR()
	ON_WM_RBUTTONUP()
	ON_COMMAND(ID_MENUITEM_BEEP_ON, OnPopupMenuBeepOn)
	ON_COMMAND(ID_MENUITEM_BEEP_OFF,OnPopupMenuBeepOff)
	ON_COMMAND(ID_MENUITEM_SCREEN,OnPopupMenuScreen)
	ON_COMMAND(ID_MENUITEM_SYSTEM_DUMP,OnPopupMenuSystemDump)
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpMView Construction / extinction of the class

CGpMView::CGpMView()
{
	m_bIgnoreRightUp = false ;

}

CGpMView::~CGpMView()
{
}

BOOL CGpMView::PreCreateWindow(CREATESTRUCT& cs)
{	
	//	Change Window size
	cs.cx = GP_SCREEN_X ;
	cs.cy = GP_SCREEN_Y ;

	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CGpMView Draw

void CGpMView::OnDraw(CDC* pDC)
{
	CGpMDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

    int nCount = pDoc->GetContentsCount();


	// Draw the line for debug
	{
		CGpWinPen Pen( 7,0) ;
		CPen *pOldPen = pDC->SelectObject((CPen* )&Pen);
		int OldBkMode = pDC->SetBkMode( OPAQUE );
		pDC->MoveTo(0,0);
	//	pDC->LineTo(0,480);
	//	pDC->LineTo(640,480);
	//	pDC->LineTo(640,0);
		pDC->LineTo(0,pDoc->m_szGP.cy);
		pDC->LineTo(pDoc->m_szGP.cx,pDoc->m_szGP.cy);
		pDC->LineTo(pDoc->m_szGP.cx,0);
		pDC->LineTo(0,0);

		pDC->SetBkMode(OldBkMode );
		pDC->SelectObject(pOldPen);
	}

    for (int i=0 ; i<nCount; i++){
		pDoc->GetContents(i)->Draw(pDC);
	}
}

void CGpMView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;

	sizeTotal.cx = GP_SCREEN_X ;
	sizeTotal.cy = GP_SCREEN_Y ;
	
	SetScrollSizes(MM_TEXT, sizeTotal);
}

/////////////////////////////////////////////////////////////////////////////
// CGpMView NẌ

BOOL CGpMView::OnPreparePrinting(CPrintInfo* pInfo)
{
	return DoPreparePrinting(pInfo);
}

void CGpMView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

void CGpMView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

/////////////////////////////////////////////////////////////////////////////
// CGpMView diagnose a class

#ifdef _DEBUG
void CGpMView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CGpMView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CGpMDoc* CGpMView::GetDocument() 
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGpMDoc)));
	return (CGpMDoc*)m_pDocument;
}
#endif //_DEBUG





/////////////////////////////////////////////////////////////////////////////
// CGpMView NXMessage Handler

void CGpMView::OnLButtonDown(UINT nFlags, CPoint point)
{

	// Keep DC and Mouse
    CClientDC dc(this);
    OnPrepareDC(&dc);
    dc.DPtoLP(&point);
    SetCapture();

	//	Start drawing
	ActionCheck(CurrentGpPen()->ActionDown(nFlags,point,&dc),&dc) ;
}


void CGpMView::OnMouseMove(UINT nFlags, CPoint point)
{
    if (GetCapture() == this) {
        CClientDC dc(this);
        OnPrepareDC(&dc);
        dc.DPtoLP(&point);

		//	Start drawing
		ActionCheck(CurrentGpPen()->ActionMove(nFlags,point,&dc),&dc) ;
	}

	//	out put to status bar
	CString strPosition ;
	strPosition.Format( _T(" %5d , %5d "), point.x, point.y ) ;
	theApp.m_pMainFrame->PutStatusBarOrg( (LPCTSTR)strPosition ) ;
}


void CGpMView::OnLButtonUp(UINT nFlags, CPoint point)
{
    if (GetCapture() == this) {
        CClientDC dc(this);
        OnPrepareDC(&dc);
        dc.DPtoLP(&point);

		//	Start drawing
		ActionCheck(CurrentGpPen()->ActionUp(nFlags,point,&dc),&dc) ;
    }
}

void CGpMView::OnRButtonDown(UINT nFlags, CPoint point) 
{
    if (GetCapture() == this) {
        CClientDC dc(this);
        OnPrepareDC(&dc);
        dc.DPtoLP(&point);

		//	check use Right click
		if( CurrentGpPen()->UseRButton() )
		{
			//	Start drawing
			ActionCheck(CurrentGpPen()->ActionRDown(nFlags,point,&dc),&dc) ;

			//	set ignore flag
			m_bIgnoreRightUp = true ;
		}
    }
}

//
// Do Actin
//
void CGpMView::ActionCheck(int iActionCode,CDC* pDC)
{
	CContents  *pContents ;
	CMemSock* pCMemSock ;
	int iError ;

	switch( iActionCode ){
		case B_ActionOk:			//	Finish the draw : can create the contents for draw
			//	Create contents
			pContents = CurrentGpPen()->CreateContents() ;
			if( pContents ){
				//	add to pool
				GetDocument()->AddContents(pContents) ;
				pContents->Draw(pDC);

				//	Transmit to GP
				if( pCMemSock = GetDocument()->GetCMemSock() ){
					if( iError = pContents->Transition( pCMemSock) ){
						DispMtoMError( iError,pCMemSock->MtoMGetLastError() );
					}
				}
			} else {
				//	Cannot create : memory is not enough
				AfxMessageBox(IDS_NOTING_MEMORY) ;
			}
		    if (GetCapture() == this) {
		        ReleaseCapture();
			}
			break ;

		case B_ActionContinue:		// Continued
			break ;

		case B_ActionStop:			// Aborted
			// release capture
		     if (GetCapture() == this) {
		        ReleaseCapture();
			}
			break ;
	}
}

//	cancel
void CGpMView::ActionCancel()
{
    if (GetCapture() == this) {
        ReleaseCapture();
	    CClientDC dc(this);
		OnPrepareDC(&dc);

		//	cancel
		CurrentGpPen()->ActionCancel(&dc) ;
	}
}


// Get Current object
CGpPen* CGpMView::CurrentGpPen()
{
	return( theApp.GetCurrentGpPen() ) ;
}


// Change current object
void CGpMView::ChengeCurretGpPen(DWORD dwGpPen_ID) 
{
	// Cancel
	ActionCancel() ;

	// Set new object
	theApp.SetCurrentGpPen(dwGpPen_ID) ;
}

//	Icon of Pen Object is clicked
void CGpMView::OnGpPenEscT()
{
	ChengeCurretGpPen(ID_GpPenEscT) ;
}
void CGpMView::OnGpPenEscb() 
{
	ChengeCurretGpPen(ID_GpPenEsc_b) ;
}
void CGpMView::OnGpPenEscc() 
{
	ChengeCurretGpPen(ID_GpPenEsc_c) ;
}
void CGpMView::OnGpPenEscg() 
{
	ChengeCurretGpPen(ID_GpPenEsc_g) ;
}
void CGpMView::OnGpPenEscl() 
{
	ChengeCurretGpPen(ID_GpPenEsc_l) ;
}
void CGpMView::OnGpPenEscs() 
{
	ChengeCurretGpPen(ID_GpPenEsc_s) ;
}
void CGpMView::OnGpPenEsct() 
{
	ChengeCurretGpPen(ID_GpPenEsc_t) ;
}
void CGpMView::OnGpPenEscA() 
{
	ChengeCurretGpPen(ID_GpPenEscA) ;
}
void CGpMView::OnGpPenEscB() 
{
	ChengeCurretGpPen(ID_GpPenEscB) ;
}
void CGpMView::OnGpPenEscC() 
{
	ChengeCurretGpPen(ID_GpPenEscC) ;
}
void CGpMView::OnGpPenEscG() 
{
	ChengeCurretGpPen(ID_GpPenEscG) ;
}
void CGpMView::OnGpPenEscL() 
{
	ChengeCurretGpPen(ID_GpPenEscL) ;
}
void CGpMView::OnGpPenEscP() 
{
	ChengeCurretGpPen(ID_GpPenEscP) ;
}
void CGpMView::OnGpPenEscS() 
{
	ChengeCurretGpPen(ID_GpPenEscS) ;
}
void CGpMView::OnGpPenEscY() 
{
	ChengeCurretGpPen(ID_GpPenEscY) ;
}
void CGpMView::OnGpPenEscy() 
{
	ChengeCurretGpPen(ID_GpPenEsc_y) ;
}



//
//	Be black the color of backgraund
//
BOOL CGpMView::OnEraseBkgnd(CDC* pDC) 
{
    // Brush
    CBrush newBrush;
    newBrush.CreateSolidBrush( RGB_BLACK );
  
    // Change the brush
    HBRUSH hOldBrush = (HBRUSH)SetClassLong(GetSafeHwnd(),GCL_HBRBACKGROUND,(LONG)((HBRUSH)newBrush.m_hObject));
  
	// Erase
    BOOL ret = CScrollView::OnEraseBkgnd(pDC);

    //	Set old brush
	SetClassLong(GetSafeHwnd(),GCL_HBRBACKGROUND,(LONG)((HBRUSH)hOldBrush));
    return ret;	
}


// the button for bright/contrast is clicked
void CGpMView::OnAdjust() 
{
	CGpMDoc* pDoc = GetDocument();

	CAdjust Dlg(pDoc) ;

	Dlg.DoModal();
}


// the button for ShowMesssage is clicked
void CGpMView::OnShowMessage() 
{
	CGpMDoc* pDoc = GetDocument();

	if( !pDoc->IsEther() )
	{
		//	if SIO, do not support Message Command
		AfxMessageBox( IDS_SIO_MESSAGE ) ;
		return ;
	}

	CShowMessage Dlg(pDoc) ;

	Dlg.DoModal();
}

// disconnect
void CGpMView::OnLink() 
{
	CGpMDoc* pDoc = GetDocument();

	pDoc->LinkMSock( NULL );
	pDoc->Agreeto();
}


///////////////////////////////////////////////////////////////////////////////////////
// Right Click for PopUp Menu
///////////////////////////////////////////////////////////////////////////////////////
void CGpMView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	if( m_bIgnoreRightUp )
	{
		//	ignore
		m_bIgnoreRightUp = false ;
		return ;
	}

	CGpMDoc *pDoc = GetDocument() ;

	// Cancel
	ActionCancel() ;

	if(  pDoc->GetCMemSock() == NULL ){
		// Not connect
		MessageBeep(MB_ICONEXCLAMATION);
		return ;
	}
	
	CMenu menu;
	VERIFY(menu.LoadMenu(IDR_POPUP_DIRECT));
	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	if( pDoc->m_bConnected ){
		// connected with GP
		pPopup->EnableMenuItem(ID_MENUITEM_SYSTEM_DUMP,MF_ENABLED );
	}
  
	ClientToScreen(&point);
	pPopup->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this );
}


//	Beep ON
void CGpMView::OnPopupMenuBeepOn()
{
	int iError ;
	WORD wBeepOn = 0x0002 ; // ON
	
	CMemSock* pCMemSock = GetDocument()->GetCMemSock() ;
	if( pCMemSock){
		//	Beep switch is on the address 11
		if( iError = pCMemSock->MtoMESC_W(11,1,&wBeepOn) ){
			DispMtoMError( iError,pCMemSock->MtoMGetLastError() ) ;
		}
	}
}

//	Beep OFF
void CGpMView::OnPopupMenuBeepOff()
{
	int iError ;
	WORD wBeepOff = 0x0000 ; // OFF
	
	CMemSock* pCMemSock = GetDocument()->GetCMemSock() ;
	if( pCMemSock){
		//	Beep switch is on the address 11
		if( iError = pCMemSock->MtoMESC_W(11,1,&wBeepOff) ){
			DispMtoMError( iError,pCMemSock->MtoMGetLastError() ) ;
	
		}
	}
}


//	Change the screen number
void CGpMView::OnPopupMenuScreen()
{
	WORD wScreenNo ;
	int iError ;

	CMemSock* pCMemSock = GetDocument()->GetCMemSock() ;
	if( pCMemSock){
		CInputBox Dlg ;
		if( Dlg.DoModal() == IDOK ){
			wScreenNo = (WORD )Dlg.m_uScreenNo | 0x8000 ; // Forth

			//	Base screen number is on the address 8
			if( iError = pCMemSock->MtoMESC_W(15,1,&wScreenNo) ){
				DispMtoMError( iError,pCMemSock->MtoMGetLastError() ) ;
			}

		}
	}
}


// Show System Data Area
void CGpMView::OnPopupMenuSystemDump()
{
	WORD wSystemData[20] ;
	int iError ;

	CMemSock* pCMemSock = GetDocument()->GetCMemSock() ;
	if( pCMemSock){
		if( iError = pCMemSock->MtoMESC_R(0,20,wSystemData) ){
			DispMtoMError( iError,pCMemSock->MtoMGetLastError() ) ;
			return ;
		}

		CSystemDump Dlg ;

		Dlg.m_szScreenNo.Format("No.%u",wSystemData[15]);

		Dlg.m_szErrorStatus.Format("$%04X",wSystemData[11]);
		Dlg.m_szStatus.Format("$%04X",wSystemData[6]);
		Dlg.m_szDate.Format("%02d/%02d/%02d",
				((wSystemData[4]>> 4) & 0xf) * 10 + // 
                ((wSystemData[4]    ) & 0xf),       // 

				((wSystemData[5]>> 4) & 0xf) * 10 + // 
                ((wSystemData[5]    ) & 0xf),       // 

				((wSystemData[6]>> 4) & 0xf) * 10 + // 
				((wSystemData[6]    ) & 0xf) );     //
				
		Dlg.m_szTime.Format("%02d:%02d",
				((wSystemData[7]>> 4) & 0xf) * 10 + //
                ((wSystemData[7]    ) & 0xf),       //

				((wSystemData[8]>> 4) & 0xf) * 10 + //
                ((wSystemData[8]    ) & 0xf)) ;     //

		Dlg.DoModal();	
	}
}


///////////////////////////////////////////////////////////////////////////////////////
// Input key
///////////////////////////////////////////////////////////////////////////////////////
void CGpMView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	switch( nChar){
		case VK_ESCAPE:// ESC key
			ActionCancel() ;
			break ;
	}
}
